### 14.2. 定位main应用类

我们通常建议你将main应用类放在位于其他类上面的根包（root package）中。通常使用`@EnableAutoConfiguration`注解你的main类，并且隐式定义了一个基础“search package”去查找一些具体的注解。例如，如果你正在编写一个JPA应用，被`@EnableAutoConfiguration`注解的类所在包将被用来搜索`@Entity`注解。

使用根包允许你使用`@ComponentScan`注解而不需要定义一个`basePackage`属性。如果main类位于根包中，你也可以使用`@SpringBootApplication`注解。

下面是一个典型的结构：
```shell
com
 +- example
     +- myproject
         +- Application.java
         |
         +- domain
         |   +- Customer.java
         |   +- CustomerRepository.java
         |
         +- service
         |   +- CustomerService.java
         |
         +- web
             +- CustomerController.java
```
`Application.java`文件将声明`main`方法，还有基本的`@Configuration`。
```java
package com.example.myproject;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableAutoConfiguration
@ComponentScan
public class Application {

    public static void main(String[] args) {
        SpringApplication.run(Application.class, args);
    }

}
```
